/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.GrokClassifier;

public class GrokClassifierUnmarshaller
implements Unmarshaller<GrokClassifier, JsonUnmarshallerContext> {
    private static final GrokClassifierUnmarshaller INSTANCE = new GrokClassifierUnmarshaller();

    public GrokClassifier unmarshall(JsonUnmarshallerContext context) throws Exception {
        GrokClassifier.Builder grokClassifierBuilder = GrokClassifier.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    grokClassifierBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Classification", targetDepth)) {
                    context.nextToken();
                    grokClassifierBuilder.classification((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreationTime", targetDepth)) {
                    context.nextToken();
                    grokClassifierBuilder.creationTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("LastUpdated", targetDepth)) {
                    context.nextToken();
                    grokClassifierBuilder.lastUpdated((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("Version", targetDepth)) {
                    context.nextToken();
                    grokClassifierBuilder.version((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("GrokPattern", targetDepth)) {
                    context.nextToken();
                    grokClassifierBuilder.grokPattern((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CustomPatterns", targetDepth)) {
                    context.nextToken();
                    grokClassifierBuilder.customPatterns((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (GrokClassifier)grokClassifierBuilder.build();
    }

    public static GrokClassifierUnmarshaller getInstance() {
        return INSTANCE;
    }
}

