/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.GetJobRunRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetJobRunRequestModelMarshaller {
    private static final MarshallingInfo<String> JOBNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobName").isBinary(false).build();
    private static final MarshallingInfo<String> RUNID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RunId").isBinary(false).build();
    private static final MarshallingInfo<Boolean> PREDECESSORSINCLUDED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PredecessorsIncluded").isBinary(false).build();
    private static final GetJobRunRequestModelMarshaller INSTANCE = new GetJobRunRequestModelMarshaller();

    private GetJobRunRequestModelMarshaller() {
    }

    public static GetJobRunRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetJobRunRequest getJobRunRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getJobRunRequest), (String)"getJobRunRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)getJobRunRequest.jobName(), JOBNAME_BINDING);
            protocolMarshaller.marshall((Object)getJobRunRequest.runId(), RUNID_BINDING);
            protocolMarshaller.marshall((Object)getJobRunRequest.predecessorsIncluded(), PREDECESSORSINCLUDED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

