/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.GetConnectionsFilter;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetConnectionsFilterMarshaller {
    private static final MarshallingInfo<List> MATCHCRITERIA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MatchCriteria").isBinary(false).build();
    private static final MarshallingInfo<String> CONNECTIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConnectionType").isBinary(false).build();
    private static final GetConnectionsFilterMarshaller INSTANCE = new GetConnectionsFilterMarshaller();

    private GetConnectionsFilterMarshaller() {
    }

    public static GetConnectionsFilterMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetConnectionsFilter getConnectionsFilter, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)getConnectionsFilter, (String)"getConnectionsFilter");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(getConnectionsFilter.matchCriteria(), MATCHCRITERIA_BINDING);
            protocolMarshaller.marshall((Object)getConnectionsFilter.connectionTypeString(), CONNECTIONTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

