/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.GetCrawlersRequest;
import software.amazon.awssdk.services.glue.model.GetCrawlersResponse;

public class GetCrawlersIterable
implements SdkIterable<GetCrawlersResponse> {
    private final GlueClient client;
    private final GetCrawlersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetCrawlersIterable(GlueClient client, GetCrawlersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetCrawlersResponseFetcher();
    }

    public Iterator<GetCrawlersResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final GetCrawlersIterable resume(GetCrawlersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetCrawlersIterable(this.client, (GetCrawlersRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetCrawlersIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetCrawlersResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetCrawlersResponseFetcher
    implements SyncPageFetcher<GetCrawlersResponse> {
        private GetCrawlersResponseFetcher() {
        }

        public boolean hasNextPage(GetCrawlersResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetCrawlersResponse nextPage(GetCrawlersResponse previousPage) {
            if (previousPage == null) {
                return GetCrawlersIterable.this.client.getCrawlers(GetCrawlersIterable.this.firstRequest);
            }
            return GetCrawlersIterable.this.client.getCrawlers((GetCrawlersRequest)((Object)GetCrawlersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

