/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.GetConnectionsRequest;
import software.amazon.awssdk.services.glue.model.GetConnectionsResponse;

public class GetConnectionsIterable
implements SdkIterable<GetConnectionsResponse> {
    private final GlueClient client;
    private final GetConnectionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetConnectionsIterable(GlueClient client, GetConnectionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetConnectionsResponseFetcher();
    }

    public Iterator<GetConnectionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final GetConnectionsIterable resume(GetConnectionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetConnectionsIterable(this.client, (GetConnectionsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetConnectionsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetConnectionsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetConnectionsResponseFetcher
    implements SyncPageFetcher<GetConnectionsResponse> {
        private GetConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(GetConnectionsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetConnectionsResponse nextPage(GetConnectionsResponse previousPage) {
            if (previousPage == null) {
                return GetConnectionsIterable.this.client.getConnections(GetConnectionsIterable.this.firstRequest);
            }
            return GetConnectionsIterable.this.client.getConnections((GetConnectionsRequest)((Object)GetConnectionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

