/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.Column;
import software.amazon.awssdk.services.glue.model.ColumnListCopier;
import software.amazon.awssdk.services.glue.model.NameStringListCopier;
import software.amazon.awssdk.services.glue.model.Order;
import software.amazon.awssdk.services.glue.model.OrderListCopier;
import software.amazon.awssdk.services.glue.model.ParametersMapCopier;
import software.amazon.awssdk.services.glue.model.SerDeInfo;
import software.amazon.awssdk.services.glue.model.SkewedInfo;
import software.amazon.awssdk.services.glue.transform.StorageDescriptorMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StorageDescriptor
implements StructuredPojo,
ToCopyableBuilder<Builder, StorageDescriptor> {
    private final List<Column> columns;
    private final String location;
    private final String inputFormat;
    private final String outputFormat;
    private final Boolean compressed;
    private final Integer numberOfBuckets;
    private final SerDeInfo serdeInfo;
    private final List<String> bucketColumns;
    private final List<Order> sortColumns;
    private final Map<String, String> parameters;
    private final SkewedInfo skewedInfo;
    private final Boolean storedAsSubDirectories;

    private StorageDescriptor(BuilderImpl builder) {
        this.columns = builder.columns;
        this.location = builder.location;
        this.inputFormat = builder.inputFormat;
        this.outputFormat = builder.outputFormat;
        this.compressed = builder.compressed;
        this.numberOfBuckets = builder.numberOfBuckets;
        this.serdeInfo = builder.serdeInfo;
        this.bucketColumns = builder.bucketColumns;
        this.sortColumns = builder.sortColumns;
        this.parameters = builder.parameters;
        this.skewedInfo = builder.skewedInfo;
        this.storedAsSubDirectories = builder.storedAsSubDirectories;
    }

    public List<Column> columns() {
        return this.columns;
    }

    public String location() {
        return this.location;
    }

    public String inputFormat() {
        return this.inputFormat;
    }

    public String outputFormat() {
        return this.outputFormat;
    }

    public Boolean compressed() {
        return this.compressed;
    }

    public Integer numberOfBuckets() {
        return this.numberOfBuckets;
    }

    public SerDeInfo serdeInfo() {
        return this.serdeInfo;
    }

    public List<String> bucketColumns() {
        return this.bucketColumns;
    }

    public List<Order> sortColumns() {
        return this.sortColumns;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public SkewedInfo skewedInfo() {
        return this.skewedInfo;
    }

    public Boolean storedAsSubDirectories() {
        return this.storedAsSubDirectories;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.columns());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputFormat());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputFormat());
        hashCode = 31 * hashCode + Objects.hashCode(this.compressed());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfBuckets());
        hashCode = 31 * hashCode + Objects.hashCode(this.serdeInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketColumns());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortColumns());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.skewedInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.storedAsSubDirectories());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageDescriptor)) {
            return false;
        }
        StorageDescriptor other = (StorageDescriptor)obj;
        return Objects.equals(this.columns(), other.columns()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.inputFormat(), other.inputFormat()) && Objects.equals(this.outputFormat(), other.outputFormat()) && Objects.equals(this.compressed(), other.compressed()) && Objects.equals(this.numberOfBuckets(), other.numberOfBuckets()) && Objects.equals(this.serdeInfo(), other.serdeInfo()) && Objects.equals(this.bucketColumns(), other.bucketColumns()) && Objects.equals(this.sortColumns(), other.sortColumns()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.skewedInfo(), other.skewedInfo()) && Objects.equals(this.storedAsSubDirectories(), other.storedAsSubDirectories());
    }

    public String toString() {
        return ToString.builder((String)"StorageDescriptor").add("Columns", this.columns()).add("Location", (Object)this.location()).add("InputFormat", (Object)this.inputFormat()).add("OutputFormat", (Object)this.outputFormat()).add("Compressed", (Object)this.compressed()).add("NumberOfBuckets", (Object)this.numberOfBuckets()).add("SerdeInfo", (Object)this.serdeInfo()).add("BucketColumns", this.bucketColumns()).add("SortColumns", this.sortColumns()).add("Parameters", this.parameters()).add("SkewedInfo", (Object)this.skewedInfo()).add("StoredAsSubDirectories", (Object)this.storedAsSubDirectories()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Columns": {
                return Optional.of(clazz.cast(this.columns()));
            }
            case "Location": {
                return Optional.of(clazz.cast(this.location()));
            }
            case "InputFormat": {
                return Optional.of(clazz.cast(this.inputFormat()));
            }
            case "OutputFormat": {
                return Optional.of(clazz.cast(this.outputFormat()));
            }
            case "Compressed": {
                return Optional.of(clazz.cast(this.compressed()));
            }
            case "NumberOfBuckets": {
                return Optional.of(clazz.cast(this.numberOfBuckets()));
            }
            case "SerdeInfo": {
                return Optional.of(clazz.cast(this.serdeInfo()));
            }
            case "BucketColumns": {
                return Optional.of(clazz.cast(this.bucketColumns()));
            }
            case "SortColumns": {
                return Optional.of(clazz.cast(this.sortColumns()));
            }
            case "Parameters": {
                return Optional.of(clazz.cast(this.parameters()));
            }
            case "SkewedInfo": {
                return Optional.of(clazz.cast(this.skewedInfo()));
            }
            case "StoredAsSubDirectories": {
                return Optional.of(clazz.cast(this.storedAsSubDirectories()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StorageDescriptorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Column> columns;
        private String location;
        private String inputFormat;
        private String outputFormat;
        private Boolean compressed;
        private Integer numberOfBuckets;
        private SerDeInfo serdeInfo;
        private List<String> bucketColumns;
        private List<Order> sortColumns;
        private Map<String, String> parameters;
        private SkewedInfo skewedInfo;
        private Boolean storedAsSubDirectories;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageDescriptor model) {
            this.columns(model.columns);
            this.location(model.location);
            this.inputFormat(model.inputFormat);
            this.outputFormat(model.outputFormat);
            this.compressed(model.compressed);
            this.numberOfBuckets(model.numberOfBuckets);
            this.serdeInfo(model.serdeInfo);
            this.bucketColumns(model.bucketColumns);
            this.sortColumns(model.sortColumns);
            this.parameters(model.parameters);
            this.skewedInfo(model.skewedInfo);
            this.storedAsSubDirectories(model.storedAsSubDirectories);
        }

        public final Collection<Column.Builder> getColumns() {
            return this.columns != null ? (Collection)this.columns.stream().map(Column::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder columns(Collection<Column> columns) {
            this.columns = ColumnListCopier.copy(columns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columns(Column ... columns) {
            this.columns(Arrays.asList(columns));
            return this;
        }

        public final void setColumns(Collection<Column.BuilderImpl> columns) {
            this.columns = ColumnListCopier.copyFromBuilder(columns);
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getInputFormat() {
            return this.inputFormat;
        }

        @Override
        public final Builder inputFormat(String inputFormat) {
            this.inputFormat = inputFormat;
            return this;
        }

        public final void setInputFormat(String inputFormat) {
            this.inputFormat = inputFormat;
        }

        public final String getOutputFormat() {
            return this.outputFormat;
        }

        @Override
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        public final Boolean getCompressed() {
            return this.compressed;
        }

        @Override
        public final Builder compressed(Boolean compressed) {
            this.compressed = compressed;
            return this;
        }

        public final void setCompressed(Boolean compressed) {
            this.compressed = compressed;
        }

        public final Integer getNumberOfBuckets() {
            return this.numberOfBuckets;
        }

        @Override
        public final Builder numberOfBuckets(Integer numberOfBuckets) {
            this.numberOfBuckets = numberOfBuckets;
            return this;
        }

        public final void setNumberOfBuckets(Integer numberOfBuckets) {
            this.numberOfBuckets = numberOfBuckets;
        }

        public final SerDeInfo.Builder getSerdeInfo() {
            return this.serdeInfo != null ? this.serdeInfo.toBuilder() : null;
        }

        @Override
        public final Builder serdeInfo(SerDeInfo serdeInfo) {
            this.serdeInfo = serdeInfo;
            return this;
        }

        public final void setSerdeInfo(SerDeInfo.BuilderImpl serdeInfo) {
            this.serdeInfo = serdeInfo != null ? serdeInfo.build() : null;
        }

        public final Collection<String> getBucketColumns() {
            return this.bucketColumns;
        }

        @Override
        public final Builder bucketColumns(Collection<String> bucketColumns) {
            this.bucketColumns = NameStringListCopier.copy(bucketColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bucketColumns(String ... bucketColumns) {
            this.bucketColumns(Arrays.asList(bucketColumns));
            return this;
        }

        public final void setBucketColumns(Collection<String> bucketColumns) {
            this.bucketColumns = NameStringListCopier.copy(bucketColumns);
        }

        public final Collection<Order.Builder> getSortColumns() {
            return this.sortColumns != null ? (Collection)this.sortColumns.stream().map(Order::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sortColumns(Collection<Order> sortColumns) {
            this.sortColumns = OrderListCopier.copy(sortColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortColumns(Order ... sortColumns) {
            this.sortColumns(Arrays.asList(sortColumns));
            return this;
        }

        public final void setSortColumns(Collection<Order.BuilderImpl> sortColumns) {
            this.sortColumns = OrderListCopier.copyFromBuilder(sortColumns);
        }

        public final Map<String, String> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        public final SkewedInfo.Builder getSkewedInfo() {
            return this.skewedInfo != null ? this.skewedInfo.toBuilder() : null;
        }

        @Override
        public final Builder skewedInfo(SkewedInfo skewedInfo) {
            this.skewedInfo = skewedInfo;
            return this;
        }

        public final void setSkewedInfo(SkewedInfo.BuilderImpl skewedInfo) {
            this.skewedInfo = skewedInfo != null ? skewedInfo.build() : null;
        }

        public final Boolean getStoredAsSubDirectories() {
            return this.storedAsSubDirectories;
        }

        @Override
        public final Builder storedAsSubDirectories(Boolean storedAsSubDirectories) {
            this.storedAsSubDirectories = storedAsSubDirectories;
            return this;
        }

        public final void setStoredAsSubDirectories(Boolean storedAsSubDirectories) {
            this.storedAsSubDirectories = storedAsSubDirectories;
        }

        public StorageDescriptor build() {
            return new StorageDescriptor(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StorageDescriptor> {
        public Builder columns(Collection<Column> var1);

        public Builder columns(Column ... var1);

        public Builder location(String var1);

        public Builder inputFormat(String var1);

        public Builder outputFormat(String var1);

        public Builder compressed(Boolean var1);

        public Builder numberOfBuckets(Integer var1);

        public Builder serdeInfo(SerDeInfo var1);

        default public Builder serdeInfo(Consumer<SerDeInfo.Builder> serdeInfo) {
            return this.serdeInfo((SerDeInfo)((SerDeInfo.Builder)SerDeInfo.builder().apply(serdeInfo)).build());
        }

        public Builder bucketColumns(Collection<String> var1);

        public Builder bucketColumns(String ... var1);

        public Builder sortColumns(Collection<Order> var1);

        public Builder sortColumns(Order ... var1);

        public Builder parameters(Map<String, String> var1);

        public Builder skewedInfo(SkewedInfo var1);

        default public Builder skewedInfo(Consumer<SkewedInfo.Builder> skewedInfo) {
            return this.skewedInfo((SkewedInfo)((SkewedInfo.Builder)SkewedInfo.builder().apply(skewedInfo)).build());
        }

        public Builder storedAsSubDirectories(Boolean var1);
    }
}

