/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.transform.JobBookmarkEntryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class JobBookmarkEntry
implements StructuredPojo,
ToCopyableBuilder<Builder, JobBookmarkEntry> {
    private final String jobName;
    private final Integer version;
    private final Integer run;
    private final Integer attempt;
    private final String jobBookmark;

    private JobBookmarkEntry(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.version = builder.version;
        this.run = builder.run;
        this.attempt = builder.attempt;
        this.jobBookmark = builder.jobBookmark;
    }

    public String jobName() {
        return this.jobName;
    }

    public Integer version() {
        return this.version;
    }

    public Integer run() {
        return this.run;
    }

    public Integer attempt() {
        return this.attempt;
    }

    public String jobBookmark() {
        return this.jobBookmark;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.run());
        hashCode = 31 * hashCode + Objects.hashCode(this.attempt());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobBookmark());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobBookmarkEntry)) {
            return false;
        }
        JobBookmarkEntry other = (JobBookmarkEntry)obj;
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.run(), other.run()) && Objects.equals(this.attempt(), other.attempt()) && Objects.equals(this.jobBookmark(), other.jobBookmark());
    }

    public String toString() {
        return ToString.builder((String)"JobBookmarkEntry").add("JobName", (Object)this.jobName()).add("Version", (Object)this.version()).add("Run", (Object)this.run()).add("Attempt", (Object)this.attempt()).add("JobBookmark", (Object)this.jobBookmark()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobName": {
                return Optional.of(clazz.cast(this.jobName()));
            }
            case "Version": {
                return Optional.of(clazz.cast(this.version()));
            }
            case "Run": {
                return Optional.of(clazz.cast(this.run()));
            }
            case "Attempt": {
                return Optional.of(clazz.cast(this.attempt()));
            }
            case "JobBookmark": {
                return Optional.of(clazz.cast(this.jobBookmark()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobBookmarkEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobName;
        private Integer version;
        private Integer run;
        private Integer attempt;
        private String jobBookmark;

        private BuilderImpl() {
        }

        private BuilderImpl(JobBookmarkEntry model) {
            this.jobName(model.jobName);
            this.version(model.version);
            this.run(model.run);
            this.attempt(model.attempt);
            this.jobBookmark(model.jobBookmark);
        }

        public final String getJobName() {
            return this.jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final Integer getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        public final Integer getRun() {
            return this.run;
        }

        @Override
        public final Builder run(Integer run) {
            this.run = run;
            return this;
        }

        public final void setRun(Integer run) {
            this.run = run;
        }

        public final Integer getAttempt() {
            return this.attempt;
        }

        @Override
        public final Builder attempt(Integer attempt) {
            this.attempt = attempt;
            return this;
        }

        public final void setAttempt(Integer attempt) {
            this.attempt = attempt;
        }

        public final String getJobBookmark() {
            return this.jobBookmark;
        }

        @Override
        public final Builder jobBookmark(String jobBookmark) {
            this.jobBookmark = jobBookmark;
            return this;
        }

        public final void setJobBookmark(String jobBookmark) {
            this.jobBookmark = jobBookmark;
        }

        public JobBookmarkEntry build() {
            return new JobBookmarkEntry(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, JobBookmarkEntry> {
        public Builder jobName(String var1);

        public Builder version(Integer var1);

        public Builder run(Integer var1);

        public Builder attempt(Integer var1);

        public Builder jobBookmark(String var1);
    }
}

