/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.JobRun;
import software.amazon.awssdk.services.glue.model.JobRunListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetJobRunsResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetJobRunsResponse> {
    private final List<JobRun> jobRuns;
    private final String nextToken;

    private GetJobRunsResponse(BuilderImpl builder) {
        super(builder);
        this.jobRuns = builder.jobRuns;
        this.nextToken = builder.nextToken;
    }

    public List<JobRun> jobRuns() {
        return this.jobRuns;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobRuns());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJobRunsResponse)) {
            return false;
        }
        GetJobRunsResponse other = (GetJobRunsResponse)((Object)obj);
        return Objects.equals(this.jobRuns(), other.jobRuns()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetJobRunsResponse").add("JobRuns", this.jobRuns()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobRuns": {
                return Optional.of(clazz.cast(this.jobRuns()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<JobRun> jobRuns;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJobRunsResponse model) {
            this.jobRuns(model.jobRuns);
            this.nextToken(model.nextToken);
        }

        public final Collection<JobRun.Builder> getJobRuns() {
            return this.jobRuns != null ? (Collection)this.jobRuns.stream().map(JobRun::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jobRuns(Collection<JobRun> jobRuns) {
            this.jobRuns = JobRunListCopier.copy(jobRuns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobRuns(JobRun ... jobRuns) {
            this.jobRuns(Arrays.asList(jobRuns));
            return this;
        }

        public final void setJobRuns(Collection<JobRun.BuilderImpl> jobRuns) {
            this.jobRuns = JobRunListCopier.copyFromBuilder(jobRuns);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetJobRunsResponse build() {
            return new GetJobRunsResponse(this);
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    CopyableBuilder<Builder, GetJobRunsResponse> {
        public Builder jobRuns(Collection<JobRun> var1);

        public Builder jobRuns(JobRun ... var1);

        public Builder nextToken(String var1);
    }
}

