/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.transform.CodeGenEdgeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CodeGenEdge
implements StructuredPojo,
ToCopyableBuilder<Builder, CodeGenEdge> {
    private final String source;
    private final String target;
    private final String targetParameter;

    private CodeGenEdge(BuilderImpl builder) {
        this.source = builder.source;
        this.target = builder.target;
        this.targetParameter = builder.targetParameter;
    }

    public String source() {
        return this.source;
    }

    public String target() {
        return this.target;
    }

    public String targetParameter() {
        return this.targetParameter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetParameter());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeGenEdge)) {
            return false;
        }
        CodeGenEdge other = (CodeGenEdge)obj;
        return Objects.equals(this.source(), other.source()) && Objects.equals(this.target(), other.target()) && Objects.equals(this.targetParameter(), other.targetParameter());
    }

    public String toString() {
        return ToString.builder((String)"CodeGenEdge").add("Source", (Object)this.source()).add("Target", (Object)this.target()).add("TargetParameter", (Object)this.targetParameter()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Source": {
                return Optional.of(clazz.cast(this.source()));
            }
            case "Target": {
                return Optional.of(clazz.cast(this.target()));
            }
            case "TargetParameter": {
                return Optional.of(clazz.cast(this.targetParameter()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CodeGenEdgeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String source;
        private String target;
        private String targetParameter;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeGenEdge model) {
            this.source(model.source);
            this.target(model.target);
            this.targetParameter(model.targetParameter);
        }

        public final String getSource() {
            return this.source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final String getTarget() {
            return this.target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        public final String getTargetParameter() {
            return this.targetParameter;
        }

        @Override
        public final Builder targetParameter(String targetParameter) {
            this.targetParameter = targetParameter;
            return this;
        }

        public final void setTargetParameter(String targetParameter) {
            this.targetParameter = targetParameter;
        }

        public CodeGenEdge build() {
            return new CodeGenEdge(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CodeGenEdge> {
        public Builder source(String var1);

        public Builder target(String var1);

        public Builder targetParameter(String var1);
    }
}

