/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.transform.CatalogEntryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CatalogEntry
implements StructuredPojo,
ToCopyableBuilder<Builder, CatalogEntry> {
    private final String databaseName;
    private final String tableName;

    private CatalogEntry(BuilderImpl builder) {
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public String tableName() {
        return this.tableName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CatalogEntry)) {
            return false;
        }
        CatalogEntry other = (CatalogEntry)obj;
        return Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.tableName(), other.tableName());
    }

    public String toString() {
        return ToString.builder((String)"CatalogEntry").add("DatabaseName", (Object)this.databaseName()).add("TableName", (Object)this.tableName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatabaseName": {
                return Optional.of(clazz.cast(this.databaseName()));
            }
            case "TableName": {
                return Optional.of(clazz.cast(this.tableName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CatalogEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String databaseName;
        private String tableName;

        private BuilderImpl() {
        }

        private BuilderImpl(CatalogEntry model) {
            this.databaseName(model.databaseName);
            this.tableName(model.tableName);
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public CatalogEntry build() {
            return new CatalogEntry(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CatalogEntry> {
        public Builder databaseName(String var1);

        public Builder tableName(String var1);
    }
}

