/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.Partition;
import software.amazon.awssdk.services.glue.transform.StorageDescriptorUnmarshaller;

public class PartitionUnmarshaller
implements Unmarshaller<Partition, JsonUnmarshallerContext> {
    private static final PartitionUnmarshaller INSTANCE = new PartitionUnmarshaller();

    public Partition unmarshall(JsonUnmarshallerContext context) throws Exception {
        Partition.Builder partitionBuilder = Partition.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Values", targetDepth)) {
                    context.nextToken();
                    partitionBuilder.values(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("DatabaseName", targetDepth)) {
                    context.nextToken();
                    partitionBuilder.databaseName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("TableName", targetDepth)) {
                    context.nextToken();
                    partitionBuilder.tableName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreationTime", targetDepth)) {
                    context.nextToken();
                    partitionBuilder.creationTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("LastAccessTime", targetDepth)) {
                    context.nextToken();
                    partitionBuilder.lastAccessTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("StorageDescriptor", targetDepth)) {
                    context.nextToken();
                    partitionBuilder.storageDescriptor(StorageDescriptorUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Parameters", targetDepth)) {
                    context.nextToken();
                    partitionBuilder.parameters(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("LastAnalyzedTime", targetDepth)) {
                    context.nextToken();
                    partitionBuilder.lastAnalyzedTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Partition)partitionBuilder.build();
    }

    public static PartitionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

