/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.PartitionError;
import software.amazon.awssdk.services.glue.transform.ErrorDetailUnmarshaller;

public class PartitionErrorUnmarshaller
implements Unmarshaller<PartitionError, JsonUnmarshallerContext> {
    private static final PartitionErrorUnmarshaller INSTANCE = new PartitionErrorUnmarshaller();

    public PartitionError unmarshall(JsonUnmarshallerContext context) throws Exception {
        PartitionError.Builder partitionErrorBuilder = PartitionError.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("PartitionValues", targetDepth)) {
                    context.nextToken();
                    partitionErrorBuilder.partitionValues(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("ErrorDetail", targetDepth)) {
                    context.nextToken();
                    partitionErrorBuilder.errorDetail(ErrorDetailUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (PartitionError)partitionErrorBuilder.build();
    }

    public static PartitionErrorUnmarshaller getInstance() {
        return INSTANCE;
    }
}

