/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.JobUpdate;
import software.amazon.awssdk.services.glue.transform.ConnectionsListUnmarshaller;
import software.amazon.awssdk.services.glue.transform.ExecutionPropertyUnmarshaller;
import software.amazon.awssdk.services.glue.transform.JobCommandUnmarshaller;

public class JobUpdateUnmarshaller
implements Unmarshaller<JobUpdate, JsonUnmarshallerContext> {
    private static final JobUpdateUnmarshaller INSTANCE = new JobUpdateUnmarshaller();

    public JobUpdate unmarshall(JsonUnmarshallerContext context) throws Exception {
        JobUpdate.Builder jobUpdateBuilder = JobUpdate.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    jobUpdateBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("LogUri", targetDepth)) {
                    context.nextToken();
                    jobUpdateBuilder.logUri((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Role", targetDepth)) {
                    context.nextToken();
                    jobUpdateBuilder.role((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ExecutionProperty", targetDepth)) {
                    context.nextToken();
                    jobUpdateBuilder.executionProperty(ExecutionPropertyUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Command", targetDepth)) {
                    context.nextToken();
                    jobUpdateBuilder.command(JobCommandUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("DefaultArguments", targetDepth)) {
                    context.nextToken();
                    jobUpdateBuilder.defaultArguments(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("Connections", targetDepth)) {
                    context.nextToken();
                    jobUpdateBuilder.connections(ConnectionsListUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("MaxRetries", targetDepth)) {
                    context.nextToken();
                    jobUpdateBuilder.maxRetries((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("AllocatedCapacity", targetDepth)) {
                    context.nextToken();
                    jobUpdateBuilder.allocatedCapacity((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (JobUpdate)jobUpdateBuilder.build();
    }

    public static JobUpdateUnmarshaller getInstance() {
        return INSTANCE;
    }
}

