/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.JdbcTarget;

@SdkInternalApi
public class JdbcTargetMarshaller {
    private static final MarshallingInfo<String> CONNECTIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConnectionName").build();
    private static final MarshallingInfo<String> PATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Path").build();
    private static final MarshallingInfo<List> EXCLUSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Exclusions").build();
    private static final JdbcTargetMarshaller INSTANCE = new JdbcTargetMarshaller();

    public static JdbcTargetMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(JdbcTarget jdbcTarget, ProtocolMarshaller protocolMarshaller) {
        if (jdbcTarget == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)jdbcTarget.connectionName(), CONNECTIONNAME_BINDING);
            protocolMarshaller.marshall((Object)jdbcTarget.path(), PATH_BINDING);
            protocolMarshaller.marshall(jdbcTarget.exclusions(), EXCLUSIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

