/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.CrawlerTargets;

@SdkInternalApi
public class CrawlerTargetsMarshaller {
    private static final MarshallingInfo<List> S3TARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Targets").build();
    private static final MarshallingInfo<List> JDBCTARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JdbcTargets").build();
    private static final CrawlerTargetsMarshaller INSTANCE = new CrawlerTargetsMarshaller();

    public static CrawlerTargetsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CrawlerTargets crawlerTargets, ProtocolMarshaller protocolMarshaller) {
        if (crawlerTargets == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(crawlerTargets.s3Targets(), S3TARGETS_BINDING);
            protocolMarshaller.marshall(crawlerTargets.jdbcTargets(), JDBCTARGETS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

