/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.ConnectionInput;

@SdkInternalApi
public class ConnectionInputMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> CONNECTIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConnectionType").build();
    private static final MarshallingInfo<List> MATCHCRITERIA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MatchCriteria").build();
    private static final MarshallingInfo<Map> CONNECTIONPROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConnectionProperties").build();
    private static final MarshallingInfo<StructuredPojo> PHYSICALCONNECTIONREQUIREMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PhysicalConnectionRequirements").build();
    private static final ConnectionInputMarshaller INSTANCE = new ConnectionInputMarshaller();

    public static ConnectionInputMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ConnectionInput connectionInput, ProtocolMarshaller protocolMarshaller) {
        if (connectionInput == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)connectionInput.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)connectionInput.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)connectionInput.connectionTypeString(), CONNECTIONTYPE_BINDING);
            protocolMarshaller.marshall(connectionInput.matchCriteria(), MATCHCRITERIA_BINDING);
            protocolMarshaller.marshall(connectionInput.connectionPropertiesStrings(), CONNECTIONPROPERTIES_BINDING);
            protocolMarshaller.marshall((Object)connectionInput.physicalConnectionRequirements(), PHYSICALCONNECTIONREQUIREMENTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

