/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.CodeGenNodeArg;

public class CodeGenNodeArgUnmarshaller
implements Unmarshaller<CodeGenNodeArg, JsonUnmarshallerContext> {
    private static final CodeGenNodeArgUnmarshaller INSTANCE = new CodeGenNodeArgUnmarshaller();

    public CodeGenNodeArg unmarshall(JsonUnmarshallerContext context) throws Exception {
        CodeGenNodeArg.Builder codeGenNodeArgBuilder = CodeGenNodeArg.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    codeGenNodeArgBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Value", targetDepth)) {
                    context.nextToken();
                    codeGenNodeArgBuilder.value((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Param", targetDepth)) {
                    context.nextToken();
                    codeGenNodeArgBuilder.param((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (CodeGenNodeArg)codeGenNodeArgBuilder.build();
    }

    public static CodeGenNodeArgUnmarshaller getInstance() {
        return INSTANCE;
    }
}

