/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.BatchCreatePartitionRequest;

@SdkInternalApi
public class BatchCreatePartitionRequestModelMarshaller {
    private static final MarshallingInfo<String> CATALOGID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CatalogId").build();
    private static final MarshallingInfo<String> DATABASENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseName").build();
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").build();
    private static final MarshallingInfo<List> PARTITIONINPUTLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PartitionInputList").build();
    private static final BatchCreatePartitionRequestModelMarshaller INSTANCE = new BatchCreatePartitionRequestModelMarshaller();

    public static BatchCreatePartitionRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchCreatePartitionRequest batchCreatePartitionRequest, ProtocolMarshaller protocolMarshaller) {
        if (batchCreatePartitionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)batchCreatePartitionRequest.catalogId(), CATALOGID_BINDING);
            protocolMarshaller.marshall((Object)batchCreatePartitionRequest.databaseName(), DATABASENAME_BINDING);
            protocolMarshaller.marshall((Object)batchCreatePartitionRequest.tableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall(batchCreatePartitionRequest.partitionInputList(), PARTITIONINPUTLIST_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

