/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsRequest;
import software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsResponse;

public final class GetUserDefinedFunctionsPaginator
implements SdkIterable<GetUserDefinedFunctionsResponse> {
    private final GlueClient client;
    private final GetUserDefinedFunctionsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public GetUserDefinedFunctionsPaginator(GlueClient client, GetUserDefinedFunctionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetUserDefinedFunctionsResponseFetcher();
    }

    public Iterator<GetUserDefinedFunctionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class GetUserDefinedFunctionsResponseFetcher
    implements NextPageFetcher<GetUserDefinedFunctionsResponse> {
        private GetUserDefinedFunctionsResponseFetcher() {
        }

        public boolean hasNextPage(GetUserDefinedFunctionsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetUserDefinedFunctionsResponse nextPage(GetUserDefinedFunctionsResponse previousPage) {
            if (previousPage == null) {
                return GetUserDefinedFunctionsPaginator.this.client.getUserDefinedFunctions(GetUserDefinedFunctionsPaginator.this.firstRequest);
            }
            return GetUserDefinedFunctionsPaginator.this.client.getUserDefinedFunctions((GetUserDefinedFunctionsRequest)((Object)GetUserDefinedFunctionsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

