/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.GetDatabasesRequest;
import software.amazon.awssdk.services.glue.model.GetDatabasesResponse;

public final class GetDatabasesPaginator
implements SdkIterable<GetDatabasesResponse> {
    private final GlueClient client;
    private final GetDatabasesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public GetDatabasesPaginator(GlueClient client, GetDatabasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetDatabasesResponseFetcher();
    }

    public Iterator<GetDatabasesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class GetDatabasesResponseFetcher
    implements NextPageFetcher<GetDatabasesResponse> {
        private GetDatabasesResponseFetcher() {
        }

        public boolean hasNextPage(GetDatabasesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetDatabasesResponse nextPage(GetDatabasesResponse previousPage) {
            if (previousPage == null) {
                return GetDatabasesPaginator.this.client.getDatabases(GetDatabasesPaginator.this.firstRequest);
            }
            return GetDatabasesPaginator.this.client.getDatabases((GetDatabasesRequest)((Object)GetDatabasesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

