/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.glue.model.ConnectionInput;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateConnectionRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, UpdateConnectionRequest> {
    private final String catalogId;
    private final String name;
    private final ConnectionInput connectionInput;

    private UpdateConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.name = builder.name;
        this.connectionInput = builder.connectionInput;
    }

    public String catalogId() {
        return this.catalogId;
    }

    public String name() {
        return this.name;
    }

    public ConnectionInput connectionInput() {
        return this.connectionInput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionInput());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectionRequest)) {
            return false;
        }
        UpdateConnectionRequest other = (UpdateConnectionRequest)((Object)obj);
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.connectionInput(), other.connectionInput());
    }

    public String toString() {
        return ToString.builder((String)"UpdateConnectionRequest").add("CatalogId", (Object)this.catalogId()).add("Name", (Object)this.name()).add("ConnectionInput", (Object)this.connectionInput()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.of(clazz.cast(this.catalogId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "ConnectionInput": {
                return Optional.of(clazz.cast(this.connectionInput()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String catalogId;
        private String name;
        private ConnectionInput connectionInput;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectionRequest model) {
            this.catalogId(model.catalogId);
            this.name(model.name);
            this.connectionInput(model.connectionInput);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final ConnectionInput.Builder getConnectionInput() {
            return this.connectionInput != null ? this.connectionInput.toBuilder() : null;
        }

        @Override
        public final Builder connectionInput(ConnectionInput connectionInput) {
            this.connectionInput = connectionInput;
            return this;
        }

        public final void setConnectionInput(ConnectionInput.BuilderImpl connectionInput) {
            this.connectionInput = connectionInput != null ? connectionInput.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateConnectionRequest build() {
            return new UpdateConnectionRequest(this);
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    CopyableBuilder<Builder, UpdateConnectionRequest> {
        public Builder catalogId(String var1);

        public Builder name(String var1);

        public Builder connectionInput(ConnectionInput var1);

        default public Builder connectionInput(Consumer<ConnectionInput.Builder> connectionInput) {
            return this.connectionInput((ConnectionInput)((ConnectionInput.Builder)ConnectionInput.builder().apply(connectionInput)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

