/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.Action;
import software.amazon.awssdk.services.glue.model.ActionListCopier;
import software.amazon.awssdk.services.glue.model.Predicate;
import software.amazon.awssdk.services.glue.transform.TriggerUpdateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TriggerUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, TriggerUpdate> {
    private final String name;
    private final String description;
    private final String schedule;
    private final List<Action> actions;
    private final Predicate predicate;

    private TriggerUpdate(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.schedule = builder.schedule;
        this.actions = builder.actions;
        this.predicate = builder.predicate;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String schedule() {
        return this.schedule;
    }

    public List<Action> actions() {
        return this.actions;
    }

    public Predicate predicate() {
        return this.predicate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.actions());
        hashCode = 31 * hashCode + Objects.hashCode(this.predicate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TriggerUpdate)) {
            return false;
        }
        TriggerUpdate other = (TriggerUpdate)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.actions(), other.actions()) && Objects.equals(this.predicate(), other.predicate());
    }

    public String toString() {
        return ToString.builder((String)"TriggerUpdate").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Schedule", (Object)this.schedule()).add("Actions", this.actions()).add("Predicate", (Object)this.predicate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Schedule": {
                return Optional.of(clazz.cast(this.schedule()));
            }
            case "Actions": {
                return Optional.of(clazz.cast(this.actions()));
            }
            case "Predicate": {
                return Optional.of(clazz.cast(this.predicate()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TriggerUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String schedule;
        private List<Action> actions;
        private Predicate predicate;

        private BuilderImpl() {
        }

        private BuilderImpl(TriggerUpdate model) {
            this.name(model.name);
            this.description(model.description);
            this.schedule(model.schedule);
            this.actions(model.actions);
            this.predicate(model.predicate);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSchedule() {
            return this.schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        public final Collection<Action.Builder> getActions() {
            return this.actions != null ? (Collection)this.actions.stream().map(Action::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actions(Collection<Action> actions) {
            this.actions = ActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Action ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        public final void setActions(Collection<Action.BuilderImpl> actions) {
            this.actions = ActionListCopier.copyFromBuilder(actions);
        }

        public final Predicate.Builder getPredicate() {
            return this.predicate != null ? this.predicate.toBuilder() : null;
        }

        @Override
        public final Builder predicate(Predicate predicate) {
            this.predicate = predicate;
            return this;
        }

        public final void setPredicate(Predicate.BuilderImpl predicate) {
            this.predicate = predicate != null ? predicate.build() : null;
        }

        public TriggerUpdate build() {
            return new TriggerUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TriggerUpdate> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder schedule(String var1);

        public Builder actions(Collection<Action> var1);

        public Builder actions(Action ... var1);

        public Builder predicate(Predicate var1);

        default public Builder predicate(Consumer<Predicate.Builder> predicate) {
            return this.predicate((Predicate)((Predicate.Builder)Predicate.builder().apply(predicate)).build());
        }
    }
}

