/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.glue.model.GetTableVersionsListCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.TableVersion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetTableVersionsResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetTableVersionsResponse> {
    private final List<TableVersion> tableVersions;
    private final String nextToken;

    private GetTableVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.tableVersions = builder.tableVersions;
        this.nextToken = builder.nextToken;
    }

    public List<TableVersion> tableVersions() {
        return this.tableVersions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tableVersions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTableVersionsResponse)) {
            return false;
        }
        GetTableVersionsResponse other = (GetTableVersionsResponse)((Object)obj);
        return Objects.equals(this.tableVersions(), other.tableVersions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetTableVersionsResponse").add("TableVersions", this.tableVersions()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableVersions": {
                return Optional.of(clazz.cast(this.tableVersions()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<TableVersion> tableVersions;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTableVersionsResponse model) {
            this.tableVersions(model.tableVersions);
            this.nextToken(model.nextToken);
        }

        public final Collection<TableVersion.Builder> getTableVersions() {
            return this.tableVersions != null ? (Collection)this.tableVersions.stream().map(TableVersion::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tableVersions(Collection<TableVersion> tableVersions) {
            this.tableVersions = GetTableVersionsListCopier.copy(tableVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableVersions(TableVersion ... tableVersions) {
            this.tableVersions(Arrays.asList(tableVersions));
            return this;
        }

        public final void setTableVersions(Collection<TableVersion.BuilderImpl> tableVersions) {
            this.tableVersions = GetTableVersionsListCopier.copyFromBuilder(tableVersions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetTableVersionsResponse build() {
            return new GetTableVersionsResponse(this);
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    CopyableBuilder<Builder, GetTableVersionsResponse> {
        public Builder tableVersions(Collection<TableVersion> var1);

        public Builder tableVersions(TableVersion ... var1);

        public Builder nextToken(String var1);
    }
}

