/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.transform.CatalogImportStatusMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CatalogImportStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, CatalogImportStatus> {
    private final Boolean importCompleted;
    private final Instant importTime;
    private final String importedBy;

    private CatalogImportStatus(BuilderImpl builder) {
        this.importCompleted = builder.importCompleted;
        this.importTime = builder.importTime;
        this.importedBy = builder.importedBy;
    }

    public Boolean importCompleted() {
        return this.importCompleted;
    }

    public Instant importTime() {
        return this.importTime;
    }

    public String importedBy() {
        return this.importedBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.importCompleted());
        hashCode = 31 * hashCode + Objects.hashCode(this.importTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.importedBy());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CatalogImportStatus)) {
            return false;
        }
        CatalogImportStatus other = (CatalogImportStatus)obj;
        return Objects.equals(this.importCompleted(), other.importCompleted()) && Objects.equals(this.importTime(), other.importTime()) && Objects.equals(this.importedBy(), other.importedBy());
    }

    public String toString() {
        return ToString.builder((String)"CatalogImportStatus").add("ImportCompleted", (Object)this.importCompleted()).add("ImportTime", (Object)this.importTime()).add("ImportedBy", (Object)this.importedBy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImportCompleted": {
                return Optional.of(clazz.cast(this.importCompleted()));
            }
            case "ImportTime": {
                return Optional.of(clazz.cast(this.importTime()));
            }
            case "ImportedBy": {
                return Optional.of(clazz.cast(this.importedBy()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CatalogImportStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean importCompleted;
        private Instant importTime;
        private String importedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(CatalogImportStatus model) {
            this.importCompleted(model.importCompleted);
            this.importTime(model.importTime);
            this.importedBy(model.importedBy);
        }

        public final Boolean getImportCompleted() {
            return this.importCompleted;
        }

        @Override
        public final Builder importCompleted(Boolean importCompleted) {
            this.importCompleted = importCompleted;
            return this;
        }

        public final void setImportCompleted(Boolean importCompleted) {
            this.importCompleted = importCompleted;
        }

        public final Instant getImportTime() {
            return this.importTime;
        }

        @Override
        public final Builder importTime(Instant importTime) {
            this.importTime = importTime;
            return this;
        }

        public final void setImportTime(Instant importTime) {
            this.importTime = importTime;
        }

        public final String getImportedBy() {
            return this.importedBy;
        }

        @Override
        public final Builder importedBy(String importedBy) {
            this.importedBy = importedBy;
            return this;
        }

        public final void setImportedBy(String importedBy) {
            this.importedBy = importedBy;
        }

        public CatalogImportStatus build() {
            return new CatalogImportStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CatalogImportStatus> {
        public Builder importCompleted(Boolean var1);

        public Builder importTime(Instant var1);

        public Builder importedBy(String var1);
    }
}

