/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.glue.model.BatchDeleteTableNameListCopier;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchDeleteTableRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, BatchDeleteTableRequest> {
    private final String catalogId;
    private final String databaseName;
    private final List<String> tablesToDelete;

    private BatchDeleteTableRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.tablesToDelete = builder.tablesToDelete;
    }

    public String catalogId() {
        return this.catalogId;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public List<String> tablesToDelete() {
        return this.tablesToDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tablesToDelete());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteTableRequest)) {
            return false;
        }
        BatchDeleteTableRequest other = (BatchDeleteTableRequest)((Object)obj);
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.tablesToDelete(), other.tablesToDelete());
    }

    public String toString() {
        return ToString.builder((String)"BatchDeleteTableRequest").add("CatalogId", (Object)this.catalogId()).add("DatabaseName", (Object)this.databaseName()).add("TablesToDelete", this.tablesToDelete()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.of(clazz.cast(this.catalogId()));
            }
            case "DatabaseName": {
                return Optional.of(clazz.cast(this.databaseName()));
            }
            case "TablesToDelete": {
                return Optional.of(clazz.cast(this.tablesToDelete()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String catalogId;
        private String databaseName;
        private List<String> tablesToDelete;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteTableRequest model) {
            this.catalogId(model.catalogId);
            this.databaseName(model.databaseName);
            this.tablesToDelete(model.tablesToDelete);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final Collection<String> getTablesToDelete() {
            return this.tablesToDelete;
        }

        @Override
        public final Builder tablesToDelete(Collection<String> tablesToDelete) {
            this.tablesToDelete = BatchDeleteTableNameListCopier.copy(tablesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tablesToDelete(String ... tablesToDelete) {
            this.tablesToDelete(Arrays.asList(tablesToDelete));
            return this;
        }

        public final void setTablesToDelete(Collection<String> tablesToDelete) {
            this.tablesToDelete = BatchDeleteTableNameListCopier.copy(tablesToDelete);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteTableRequest build() {
            return new BatchDeleteTableRequest(this);
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    CopyableBuilder<Builder, BatchDeleteTableRequest> {
        public Builder catalogId(String var1);

        public Builder databaseName(String var1);

        public Builder tablesToDelete(Collection<String> var1);

        public Builder tablesToDelete(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

