/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.glue.model.BatchDeletePartitionValueListCopier;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.PartitionValueList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchDeletePartitionRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, BatchDeletePartitionRequest> {
    private final String catalogId;
    private final String databaseName;
    private final String tableName;
    private final List<PartitionValueList> partitionsToDelete;

    private BatchDeletePartitionRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.partitionsToDelete = builder.partitionsToDelete;
    }

    public String catalogId() {
        return this.catalogId;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public String tableName() {
        return this.tableName;
    }

    public List<PartitionValueList> partitionsToDelete() {
        return this.partitionsToDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionsToDelete());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeletePartitionRequest)) {
            return false;
        }
        BatchDeletePartitionRequest other = (BatchDeletePartitionRequest)((Object)obj);
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.partitionsToDelete(), other.partitionsToDelete());
    }

    public String toString() {
        return ToString.builder((String)"BatchDeletePartitionRequest").add("CatalogId", (Object)this.catalogId()).add("DatabaseName", (Object)this.databaseName()).add("TableName", (Object)this.tableName()).add("PartitionsToDelete", this.partitionsToDelete()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.of(clazz.cast(this.catalogId()));
            }
            case "DatabaseName": {
                return Optional.of(clazz.cast(this.databaseName()));
            }
            case "TableName": {
                return Optional.of(clazz.cast(this.tableName()));
            }
            case "PartitionsToDelete": {
                return Optional.of(clazz.cast(this.partitionsToDelete()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String catalogId;
        private String databaseName;
        private String tableName;
        private List<PartitionValueList> partitionsToDelete;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeletePartitionRequest model) {
            this.catalogId(model.catalogId);
            this.databaseName(model.databaseName);
            this.tableName(model.tableName);
            this.partitionsToDelete(model.partitionsToDelete);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Collection<PartitionValueList.Builder> getPartitionsToDelete() {
            return this.partitionsToDelete != null ? (Collection)this.partitionsToDelete.stream().map(PartitionValueList::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder partitionsToDelete(Collection<PartitionValueList> partitionsToDelete) {
            this.partitionsToDelete = BatchDeletePartitionValueListCopier.copy(partitionsToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionsToDelete(PartitionValueList ... partitionsToDelete) {
            this.partitionsToDelete(Arrays.asList(partitionsToDelete));
            return this;
        }

        public final void setPartitionsToDelete(Collection<PartitionValueList.BuilderImpl> partitionsToDelete) {
            this.partitionsToDelete = BatchDeletePartitionValueListCopier.copyFromBuilder(partitionsToDelete);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public BatchDeletePartitionRequest build() {
            return new BatchDeletePartitionRequest(this);
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    CopyableBuilder<Builder, BatchDeletePartitionRequest> {
        public Builder catalogId(String var1);

        public Builder databaseName(String var1);

        public Builder tableName(String var1);

        public Builder partitionsToDelete(Collection<PartitionValueList> var1);

        public Builder partitionsToDelete(PartitionValueList ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

