/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.TableVersion;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TableVersionMarshaller {
    private static final MarshallingInfo<StructuredPojo> TABLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Table").isBinary(false).build();
    private static final MarshallingInfo<String> VERSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VersionId").isBinary(false).build();
    private static final TableVersionMarshaller INSTANCE = new TableVersionMarshaller();

    private TableVersionMarshaller() {
    }

    public static TableVersionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TableVersion tableVersion, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)tableVersion, (String)"tableVersion");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)tableVersion.table(), TABLE_BINDING);
            protocolMarshaller.marshall((Object)tableVersion.versionId(), VERSIONID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

