/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.TableVersionError;
import software.amazon.awssdk.services.glue.transform.ErrorDetailUnmarshaller;

public class TableVersionErrorUnmarshaller
implements Unmarshaller<TableVersionError, JsonUnmarshallerContext> {
    private static final TableVersionErrorUnmarshaller INSTANCE = new TableVersionErrorUnmarshaller();

    public TableVersionError unmarshall(JsonUnmarshallerContext context) throws Exception {
        TableVersionError.Builder tableVersionErrorBuilder = TableVersionError.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("TableName", targetDepth)) {
                    context.nextToken();
                    tableVersionErrorBuilder.tableName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("VersionId", targetDepth)) {
                    context.nextToken();
                    tableVersionErrorBuilder.versionId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ErrorDetail", targetDepth)) {
                    context.nextToken();
                    tableVersionErrorBuilder.errorDetail(ErrorDetailUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (TableVersionError)tableVersionErrorBuilder.build();
    }

    public static TableVersionErrorUnmarshaller getInstance() {
        return INSTANCE;
    }
}

