/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.SecurityConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SecurityConfigurationMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTimeStamp").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ENCRYPTIONCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptionConfiguration").isBinary(false).build();
    private static final SecurityConfigurationMarshaller INSTANCE = new SecurityConfigurationMarshaller();

    private SecurityConfigurationMarshaller() {
    }

    public static SecurityConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SecurityConfiguration securityConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)securityConfiguration, (String)"securityConfiguration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)securityConfiguration.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)securityConfiguration.createdTimeStamp(), CREATEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)securityConfiguration.encryptionConfiguration(), ENCRYPTIONCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

