/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.Predicate;
import software.amazon.awssdk.services.glue.transform.ConditionUnmarshaller;

public class PredicateUnmarshaller
implements Unmarshaller<Predicate, JsonUnmarshallerContext> {
    private static final PredicateUnmarshaller INSTANCE = new PredicateUnmarshaller();

    public Predicate unmarshall(JsonUnmarshallerContext context) throws Exception {
        Predicate.Builder predicateBuilder = Predicate.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Logical", targetDepth)) {
                    context.nextToken();
                    predicateBuilder.logical((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Conditions", targetDepth)) {
                    context.nextToken();
                    predicateBuilder.conditions(new ListUnmarshaller((Unmarshaller)ConditionUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Predicate)predicateBuilder.build();
    }

    public static PredicateUnmarshaller getInstance() {
        return INSTANCE;
    }
}

