/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.PhysicalConnectionRequirements;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PhysicalConnectionRequirementsMarshaller {
    private static final MarshallingInfo<String> SUBNETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetId").isBinary(false).build();
    private static final MarshallingInfo<List> SECURITYGROUPIDLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityGroupIdList").isBinary(false).build();
    private static final MarshallingInfo<String> AVAILABILITYZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AvailabilityZone").isBinary(false).build();
    private static final PhysicalConnectionRequirementsMarshaller INSTANCE = new PhysicalConnectionRequirementsMarshaller();

    private PhysicalConnectionRequirementsMarshaller() {
    }

    public static PhysicalConnectionRequirementsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PhysicalConnectionRequirements physicalConnectionRequirements, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)physicalConnectionRequirements, (String)"physicalConnectionRequirements");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)physicalConnectionRequirements.subnetId(), SUBNETID_BINDING);
            protocolMarshaller.marshall(physicalConnectionRequirements.securityGroupIdList(), SECURITYGROUPIDLIST_BINDING);
            protocolMarshaller.marshall((Object)physicalConnectionRequirements.availabilityZone(), AVAILABILITYZONE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

