/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.PartitionInput;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PartitionInputMarshaller {
    private static final MarshallingInfo<List> VALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Values").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTACCESSTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastAccessTime").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STORAGEDESCRIPTOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StorageDescriptor").isBinary(false).build();
    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTANALYZEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastAnalyzedTime").isBinary(false).build();
    private static final PartitionInputMarshaller INSTANCE = new PartitionInputMarshaller();

    private PartitionInputMarshaller() {
    }

    public static PartitionInputMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PartitionInput partitionInput, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)partitionInput, (String)"partitionInput");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(partitionInput.values(), VALUES_BINDING);
            protocolMarshaller.marshall((Object)partitionInput.lastAccessTime(), LASTACCESSTIME_BINDING);
            protocolMarshaller.marshall((Object)partitionInput.storageDescriptor(), STORAGEDESCRIPTOR_BINDING);
            protocolMarshaller.marshall(partitionInput.parameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)partitionInput.lastAnalyzedTime(), LASTANALYZEDTIME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

