/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.MappingEntry;

public class MappingEntryUnmarshaller
implements Unmarshaller<MappingEntry, JsonUnmarshallerContext> {
    private static final MappingEntryUnmarshaller INSTANCE = new MappingEntryUnmarshaller();

    public MappingEntry unmarshall(JsonUnmarshallerContext context) throws Exception {
        MappingEntry.Builder mappingEntryBuilder = MappingEntry.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("SourceTable", targetDepth)) {
                    context.nextToken();
                    mappingEntryBuilder.sourceTable((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SourcePath", targetDepth)) {
                    context.nextToken();
                    mappingEntryBuilder.sourcePath((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SourceType", targetDepth)) {
                    context.nextToken();
                    mappingEntryBuilder.sourceType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("TargetTable", targetDepth)) {
                    context.nextToken();
                    mappingEntryBuilder.targetTable((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("TargetPath", targetDepth)) {
                    context.nextToken();
                    mappingEntryBuilder.targetPath((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("TargetType", targetDepth)) {
                    context.nextToken();
                    mappingEntryBuilder.targetType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (MappingEntry)mappingEntryBuilder.build();
    }

    public static MappingEntryUnmarshaller getInstance() {
        return INSTANCE;
    }
}

