/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.JsonClassifier;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class JsonClassifierMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTUPDATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdated").isBinary(false).build();
    private static final MarshallingInfo<Long> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Version").isBinary(false).build();
    private static final MarshallingInfo<String> JSONPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JsonPath").isBinary(false).build();
    private static final JsonClassifierMarshaller INSTANCE = new JsonClassifierMarshaller();

    private JsonClassifierMarshaller() {
    }

    public static JsonClassifierMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(JsonClassifier jsonClassifier, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)jsonClassifier, (String)"jsonClassifier");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)jsonClassifier.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)jsonClassifier.creationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)jsonClassifier.lastUpdated(), LASTUPDATED_BINDING);
            protocolMarshaller.marshall((Object)jsonClassifier.version(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)jsonClassifier.jsonPath(), JSONPATH_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

