/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.JobUpdate;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class JobUpdateMarshaller {
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<String> LOGURI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogUri").isBinary(false).build();
    private static final MarshallingInfo<String> ROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Role").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> EXECUTIONPROPERTY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionProperty").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> COMMAND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Command").isBinary(false).build();
    private static final MarshallingInfo<Map> DEFAULTARGUMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultArguments").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CONNECTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Connections").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXRETRIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxRetries").isBinary(false).build();
    private static final MarshallingInfo<Integer> ALLOCATEDCAPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllocatedCapacity").isBinary(false).build();
    private static final MarshallingInfo<Integer> TIMEOUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timeout").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> NOTIFICATIONPROPERTY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotificationProperty").isBinary(false).build();
    private static final MarshallingInfo<String> SECURITYCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityConfiguration").isBinary(false).build();
    private static final JobUpdateMarshaller INSTANCE = new JobUpdateMarshaller();

    private JobUpdateMarshaller() {
    }

    public static JobUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(JobUpdate jobUpdate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)jobUpdate, (String)"jobUpdate");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)jobUpdate.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)jobUpdate.logUri(), LOGURI_BINDING);
            protocolMarshaller.marshall((Object)jobUpdate.role(), ROLE_BINDING);
            protocolMarshaller.marshall((Object)jobUpdate.executionProperty(), EXECUTIONPROPERTY_BINDING);
            protocolMarshaller.marshall((Object)jobUpdate.command(), COMMAND_BINDING);
            protocolMarshaller.marshall(jobUpdate.defaultArguments(), DEFAULTARGUMENTS_BINDING);
            protocolMarshaller.marshall((Object)jobUpdate.connections(), CONNECTIONS_BINDING);
            protocolMarshaller.marshall((Object)jobUpdate.maxRetries(), MAXRETRIES_BINDING);
            protocolMarshaller.marshall((Object)jobUpdate.allocatedCapacity(), ALLOCATEDCAPACITY_BINDING);
            protocolMarshaller.marshall((Object)jobUpdate.timeout(), TIMEOUT_BINDING);
            protocolMarshaller.marshall((Object)jobUpdate.notificationProperty(), NOTIFICATIONPROPERTY_BINDING);
            protocolMarshaller.marshall((Object)jobUpdate.securityConfiguration(), SECURITYCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

