/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.EncryptionAtRest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EncryptionAtRestMarshaller {
    private static final MarshallingInfo<String> CATALOGENCRYPTIONMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CatalogEncryptionMode").isBinary(false).build();
    private static final MarshallingInfo<String> SSEAWSKMSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SseAwsKmsKeyId").isBinary(false).build();
    private static final EncryptionAtRestMarshaller INSTANCE = new EncryptionAtRestMarshaller();

    private EncryptionAtRestMarshaller() {
    }

    public static EncryptionAtRestMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EncryptionAtRest encryptionAtRest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)encryptionAtRest, (String)"encryptionAtRest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)encryptionAtRest.catalogEncryptionModeAsString(), CATALOGENCRYPTIONMODE_BINDING);
            protocolMarshaller.marshall((Object)encryptionAtRest.sseAwsKmsKeyId(), SSEAWSKMSKEYID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

