/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.DevEndpoint;

public class DevEndpointUnmarshaller
implements Unmarshaller<DevEndpoint, JsonUnmarshallerContext> {
    private static final DevEndpointUnmarshaller INSTANCE = new DevEndpointUnmarshaller();

    public DevEndpoint unmarshall(JsonUnmarshallerContext context) throws Exception {
        DevEndpoint.Builder devEndpointBuilder = DevEndpoint.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("EndpointName", targetDepth)) {
                    context.nextToken();
                    devEndpointBuilder.endpointName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("RoleArn", targetDepth)) {
                    context.nextToken();
                    devEndpointBuilder.roleArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SecurityGroupIds", targetDepth)) {
                    context.nextToken();
                    devEndpointBuilder.securityGroupIds(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("SubnetId", targetDepth)) {
                    context.nextToken();
                    devEndpointBuilder.subnetId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("YarnEndpointAddress", targetDepth)) {
                    context.nextToken();
                    devEndpointBuilder.yarnEndpointAddress((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("PrivateAddress", targetDepth)) {
                    context.nextToken();
                    devEndpointBuilder.privateAddress((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ZeppelinRemoteSparkInterpreterPort", targetDepth)) {
                    context.nextToken();
                    devEndpointBuilder.zeppelinRemoteSparkInterpreterPort((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("PublicAddress", targetDepth)) {
                    context.nextToken();
                    devEndpointBuilder.publicAddress((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    devEndpointBuilder.status((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("NumberOfNodes", targetDepth)) {
                    context.nextToken();
                    devEndpointBuilder.numberOfNodes((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("AvailabilityZone", targetDepth)) {
                    context.nextToken();
                    devEndpointBuilder.availabilityZone((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("VpcId", targetDepth)) {
                    context.nextToken();
                    devEndpointBuilder.vpcId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ExtraPythonLibsS3Path", targetDepth)) {
                    context.nextToken();
                    devEndpointBuilder.extraPythonLibsS3Path((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ExtraJarsS3Path", targetDepth)) {
                    context.nextToken();
                    devEndpointBuilder.extraJarsS3Path((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("FailureReason", targetDepth)) {
                    context.nextToken();
                    devEndpointBuilder.failureReason((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("LastUpdateStatus", targetDepth)) {
                    context.nextToken();
                    devEndpointBuilder.lastUpdateStatus((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreatedTimestamp", targetDepth)) {
                    context.nextToken();
                    devEndpointBuilder.createdTimestamp((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("LastModifiedTimestamp", targetDepth)) {
                    context.nextToken();
                    devEndpointBuilder.lastModifiedTimestamp((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("PublicKey", targetDepth)) {
                    context.nextToken();
                    devEndpointBuilder.publicKey((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("PublicKeys", targetDepth)) {
                    context.nextToken();
                    devEndpointBuilder.publicKeys(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("SecurityConfiguration", targetDepth)) {
                    context.nextToken();
                    devEndpointBuilder.securityConfiguration((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (DevEndpoint)devEndpointBuilder.build();
    }

    public static DevEndpointUnmarshaller getInstance() {
        return INSTANCE;
    }
}

