/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.DataCatalogEncryptionSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DataCatalogEncryptionSettingsMarshaller {
    private static final MarshallingInfo<StructuredPojo> ENCRYPTIONATREST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptionAtRest").isBinary(false).build();
    private static final DataCatalogEncryptionSettingsMarshaller INSTANCE = new DataCatalogEncryptionSettingsMarshaller();

    private DataCatalogEncryptionSettingsMarshaller() {
    }

    public static DataCatalogEncryptionSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DataCatalogEncryptionSettings dataCatalogEncryptionSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)dataCatalogEncryptionSettings, (String)"dataCatalogEncryptionSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)dataCatalogEncryptionSettings.encryptionAtRest(), ENCRYPTIONATREST_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

