/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.CreateDevEndpointRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateDevEndpointRequestModelMarshaller {
    private static final MarshallingInfo<String> ENDPOINTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndpointName").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleArn").isBinary(false).build();
    private static final MarshallingInfo<List> SECURITYGROUPIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityGroupIds").isBinary(false).build();
    private static final MarshallingInfo<String> SUBNETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetId").isBinary(false).build();
    private static final MarshallingInfo<String> PUBLICKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PublicKey").isBinary(false).build();
    private static final MarshallingInfo<List> PUBLICKEYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PublicKeys").isBinary(false).build();
    private static final MarshallingInfo<Integer> NUMBEROFNODES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfNodes").isBinary(false).build();
    private static final MarshallingInfo<String> EXTRAPYTHONLIBSS3PATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExtraPythonLibsS3Path").isBinary(false).build();
    private static final MarshallingInfo<String> EXTRAJARSS3PATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExtraJarsS3Path").isBinary(false).build();
    private static final MarshallingInfo<String> SECURITYCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityConfiguration").isBinary(false).build();
    private static final CreateDevEndpointRequestModelMarshaller INSTANCE = new CreateDevEndpointRequestModelMarshaller();

    private CreateDevEndpointRequestModelMarshaller() {
    }

    public static CreateDevEndpointRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateDevEndpointRequest createDevEndpointRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createDevEndpointRequest), (String)"createDevEndpointRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createDevEndpointRequest.endpointName(), ENDPOINTNAME_BINDING);
            protocolMarshaller.marshall((Object)createDevEndpointRequest.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall(createDevEndpointRequest.securityGroupIds(), SECURITYGROUPIDS_BINDING);
            protocolMarshaller.marshall((Object)createDevEndpointRequest.subnetId(), SUBNETID_BINDING);
            protocolMarshaller.marshall((Object)createDevEndpointRequest.publicKey(), PUBLICKEY_BINDING);
            protocolMarshaller.marshall(createDevEndpointRequest.publicKeys(), PUBLICKEYS_BINDING);
            protocolMarshaller.marshall((Object)createDevEndpointRequest.numberOfNodes(), NUMBEROFNODES_BINDING);
            protocolMarshaller.marshall((Object)createDevEndpointRequest.extraPythonLibsS3Path(), EXTRAPYTHONLIBSS3PATH_BINDING);
            protocolMarshaller.marshall((Object)createDevEndpointRequest.extraJarsS3Path(), EXTRAJARSS3PATH_BINDING);
            protocolMarshaller.marshall((Object)createDevEndpointRequest.securityConfiguration(), SECURITYCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

