/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.Connection;
import software.amazon.awssdk.services.glue.transform.PhysicalConnectionRequirementsUnmarshaller;

public class ConnectionUnmarshaller
implements Unmarshaller<Connection, JsonUnmarshallerContext> {
    private static final ConnectionUnmarshaller INSTANCE = new ConnectionUnmarshaller();

    public Connection unmarshall(JsonUnmarshallerContext context) throws Exception {
        Connection.Builder connectionBuilder = Connection.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    connectionBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    connectionBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ConnectionType", targetDepth)) {
                    context.nextToken();
                    connectionBuilder.connectionType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("MatchCriteria", targetDepth)) {
                    context.nextToken();
                    connectionBuilder.matchCriteria(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("ConnectionProperties", targetDepth)) {
                    context.nextToken();
                    connectionBuilder.connectionPropertiesWithStrings(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("PhysicalConnectionRequirements", targetDepth)) {
                    context.nextToken();
                    connectionBuilder.physicalConnectionRequirements(PhysicalConnectionRequirementsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("CreationTime", targetDepth)) {
                    context.nextToken();
                    connectionBuilder.creationTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("LastUpdatedTime", targetDepth)) {
                    context.nextToken();
                    connectionBuilder.lastUpdatedTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("LastUpdatedBy", targetDepth)) {
                    context.nextToken();
                    connectionBuilder.lastUpdatedBy((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Connection)connectionBuilder.build();
    }

    public static ConnectionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

