/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.CodeGenNode;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CodeGenNodeMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> NODETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NodeType").isBinary(false).build();
    private static final MarshallingInfo<List> ARGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Args").isBinary(false).build();
    private static final MarshallingInfo<Integer> LINENUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LineNumber").isBinary(false).build();
    private static final CodeGenNodeMarshaller INSTANCE = new CodeGenNodeMarshaller();

    private CodeGenNodeMarshaller() {
    }

    public static CodeGenNodeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CodeGenNode codeGenNode, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)codeGenNode, (String)"codeGenNode");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)codeGenNode.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)codeGenNode.nodeType(), NODETYPE_BINDING);
            protocolMarshaller.marshall(codeGenNode.args(), ARGS_BINDING);
            protocolMarshaller.marshall((Object)codeGenNode.lineNumber(), LINENUMBER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

