/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.CodeGenEdge;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CodeGenEdgeMarshaller {
    private static final MarshallingInfo<String> SOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Source").isBinary(false).build();
    private static final MarshallingInfo<String> TARGET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Target").isBinary(false).build();
    private static final MarshallingInfo<String> TARGETPARAMETER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetParameter").isBinary(false).build();
    private static final CodeGenEdgeMarshaller INSTANCE = new CodeGenEdgeMarshaller();

    private CodeGenEdgeMarshaller() {
    }

    public static CodeGenEdgeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CodeGenEdge codeGenEdge, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)codeGenEdge, (String)"codeGenEdge");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)codeGenEdge.source(), SOURCE_BINDING);
            protocolMarshaller.marshall((Object)codeGenEdge.target(), TARGET_BINDING);
            protocolMarshaller.marshall((Object)codeGenEdge.targetParameter(), TARGETPARAMETER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

