/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.CloudWatchEncryption;

public class CloudWatchEncryptionUnmarshaller
implements Unmarshaller<CloudWatchEncryption, JsonUnmarshallerContext> {
    private static final CloudWatchEncryptionUnmarshaller INSTANCE = new CloudWatchEncryptionUnmarshaller();

    public CloudWatchEncryption unmarshall(JsonUnmarshallerContext context) throws Exception {
        CloudWatchEncryption.Builder cloudWatchEncryptionBuilder = CloudWatchEncryption.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("CloudWatchEncryptionMode", targetDepth)) {
                    context.nextToken();
                    cloudWatchEncryptionBuilder.cloudWatchEncryptionMode((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("KmsKeyArn", targetDepth)) {
                    context.nextToken();
                    cloudWatchEncryptionBuilder.kmsKeyArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (CloudWatchEncryption)cloudWatchEncryptionBuilder.build();
    }

    public static CloudWatchEncryptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

