/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.Action;
import software.amazon.awssdk.services.glue.transform.NotificationPropertyUnmarshaller;

public class ActionUnmarshaller
implements Unmarshaller<Action, JsonUnmarshallerContext> {
    private static final ActionUnmarshaller INSTANCE = new ActionUnmarshaller();

    public Action unmarshall(JsonUnmarshallerContext context) throws Exception {
        Action.Builder actionBuilder = Action.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("JobName", targetDepth)) {
                    context.nextToken();
                    actionBuilder.jobName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Arguments", targetDepth)) {
                    context.nextToken();
                    actionBuilder.arguments(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("Timeout", targetDepth)) {
                    context.nextToken();
                    actionBuilder.timeout((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("NotificationProperty", targetDepth)) {
                    context.nextToken();
                    actionBuilder.notificationProperty(NotificationPropertyUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("SecurityConfiguration", targetDepth)) {
                    context.nextToken();
                    actionBuilder.securityConfiguration((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Action)actionBuilder.build();
    }

    public static ActionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

