/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.GenericMapCopier;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.NotificationProperty;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartJobRunRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, StartJobRunRequest> {
    private final String jobName;
    private final String jobRunId;
    private final Map<String, String> arguments;
    private final Integer allocatedCapacity;
    private final Integer timeout;
    private final NotificationProperty notificationProperty;
    private final String securityConfiguration;

    private StartJobRunRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.jobRunId = builder.jobRunId;
        this.arguments = builder.arguments;
        this.allocatedCapacity = builder.allocatedCapacity;
        this.timeout = builder.timeout;
        this.notificationProperty = builder.notificationProperty;
        this.securityConfiguration = builder.securityConfiguration;
    }

    public String jobName() {
        return this.jobName;
    }

    public String jobRunId() {
        return this.jobRunId;
    }

    public Map<String, String> arguments() {
        return this.arguments;
    }

    public Integer allocatedCapacity() {
        return this.allocatedCapacity;
    }

    public Integer timeout() {
        return this.timeout;
    }

    public NotificationProperty notificationProperty() {
        return this.notificationProperty;
    }

    public String securityConfiguration() {
        return this.securityConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arguments());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationProperty());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartJobRunRequest)) {
            return false;
        }
        StartJobRunRequest other = (StartJobRunRequest)((Object)obj);
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobRunId(), other.jobRunId()) && Objects.equals(this.arguments(), other.arguments()) && Objects.equals(this.allocatedCapacity(), other.allocatedCapacity()) && Objects.equals(this.timeout(), other.timeout()) && Objects.equals(this.notificationProperty(), other.notificationProperty()) && Objects.equals(this.securityConfiguration(), other.securityConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"StartJobRunRequest").add("JobName", (Object)this.jobName()).add("JobRunId", (Object)this.jobRunId()).add("Arguments", this.arguments()).add("AllocatedCapacity", (Object)this.allocatedCapacity()).add("Timeout", (Object)this.timeout()).add("NotificationProperty", (Object)this.notificationProperty()).add("SecurityConfiguration", (Object)this.securityConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "JobRunId": {
                return Optional.ofNullable(clazz.cast(this.jobRunId()));
            }
            case "Arguments": {
                return Optional.ofNullable(clazz.cast(this.arguments()));
            }
            case "AllocatedCapacity": {
                return Optional.ofNullable(clazz.cast(this.allocatedCapacity()));
            }
            case "Timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
            case "NotificationProperty": {
                return Optional.ofNullable(clazz.cast(this.notificationProperty()));
            }
            case "SecurityConfiguration": {
                return Optional.ofNullable(clazz.cast(this.securityConfiguration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String jobName;
        private String jobRunId;
        private Map<String, String> arguments = DefaultSdkAutoConstructMap.getInstance();
        private Integer allocatedCapacity;
        private Integer timeout;
        private NotificationProperty notificationProperty;
        private String securityConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(StartJobRunRequest model) {
            super(model);
            this.jobName(model.jobName);
            this.jobRunId(model.jobRunId);
            this.arguments(model.arguments);
            this.allocatedCapacity(model.allocatedCapacity);
            this.timeout(model.timeout);
            this.notificationProperty(model.notificationProperty);
            this.securityConfiguration(model.securityConfiguration);
        }

        public final String getJobName() {
            return this.jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final String getJobRunId() {
            return this.jobRunId;
        }

        @Override
        public final Builder jobRunId(String jobRunId) {
            this.jobRunId = jobRunId;
            return this;
        }

        public final void setJobRunId(String jobRunId) {
            this.jobRunId = jobRunId;
        }

        public final Map<String, String> getArguments() {
            return this.arguments;
        }

        @Override
        public final Builder arguments(Map<String, String> arguments) {
            this.arguments = GenericMapCopier.copy(arguments);
            return this;
        }

        public final void setArguments(Map<String, String> arguments) {
            this.arguments = GenericMapCopier.copy(arguments);
        }

        public final Integer getAllocatedCapacity() {
            return this.allocatedCapacity;
        }

        @Override
        public final Builder allocatedCapacity(Integer allocatedCapacity) {
            this.allocatedCapacity = allocatedCapacity;
            return this;
        }

        public final void setAllocatedCapacity(Integer allocatedCapacity) {
            this.allocatedCapacity = allocatedCapacity;
        }

        public final Integer getTimeout() {
            return this.timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public final NotificationProperty.Builder getNotificationProperty() {
            return this.notificationProperty != null ? this.notificationProperty.toBuilder() : null;
        }

        @Override
        public final Builder notificationProperty(NotificationProperty notificationProperty) {
            this.notificationProperty = notificationProperty;
            return this;
        }

        public final void setNotificationProperty(NotificationProperty.BuilderImpl notificationProperty) {
            this.notificationProperty = notificationProperty != null ? notificationProperty.build() : null;
        }

        public final String getSecurityConfiguration() {
            return this.securityConfiguration;
        }

        @Override
        public final Builder securityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        public final void setSecurityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartJobRunRequest build() {
            return new StartJobRunRequest(this);
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    CopyableBuilder<Builder, StartJobRunRequest> {
        public Builder jobName(String var1);

        public Builder jobRunId(String var1);

        public Builder arguments(Map<String, String> var1);

        public Builder allocatedCapacity(Integer var1);

        public Builder timeout(Integer var1);

        public Builder notificationProperty(NotificationProperty var1);

        default public Builder notificationProperty(Consumer<NotificationProperty.Builder> notificationProperty) {
            return this.notificationProperty((NotificationProperty)((NotificationProperty.Builder)NotificationProperty.builder().applyMutation(notificationProperty)).build());
        }

        public Builder securityConfiguration(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

