/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.ErrorDetail;
import software.amazon.awssdk.services.glue.model.ValueStringListCopier;
import software.amazon.awssdk.services.glue.transform.PartitionErrorMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PartitionError
implements StructuredPojo,
ToCopyableBuilder<Builder, PartitionError> {
    private final List<String> partitionValues;
    private final ErrorDetail errorDetail;

    private PartitionError(BuilderImpl builder) {
        this.partitionValues = builder.partitionValues;
        this.errorDetail = builder.errorDetail;
    }

    public List<String> partitionValues() {
        return this.partitionValues;
    }

    public ErrorDetail errorDetail() {
        return this.errorDetail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorDetail());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartitionError)) {
            return false;
        }
        PartitionError other = (PartitionError)obj;
        return Objects.equals(this.partitionValues(), other.partitionValues()) && Objects.equals(this.errorDetail(), other.errorDetail());
    }

    public String toString() {
        return ToString.builder((String)"PartitionError").add("PartitionValues", this.partitionValues()).add("ErrorDetail", (Object)this.errorDetail()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PartitionValues": {
                return Optional.ofNullable(clazz.cast(this.partitionValues()));
            }
            case "ErrorDetail": {
                return Optional.ofNullable(clazz.cast(this.errorDetail()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PartitionErrorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> partitionValues = DefaultSdkAutoConstructList.getInstance();
        private ErrorDetail errorDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(PartitionError model) {
            this.partitionValues(model.partitionValues);
            this.errorDetail(model.errorDetail);
        }

        public final Collection<String> getPartitionValues() {
            return this.partitionValues;
        }

        @Override
        public final Builder partitionValues(Collection<String> partitionValues) {
            this.partitionValues = ValueStringListCopier.copy(partitionValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionValues(String ... partitionValues) {
            this.partitionValues(Arrays.asList(partitionValues));
            return this;
        }

        public final void setPartitionValues(Collection<String> partitionValues) {
            this.partitionValues = ValueStringListCopier.copy(partitionValues);
        }

        public final ErrorDetail.Builder getErrorDetail() {
            return this.errorDetail != null ? this.errorDetail.toBuilder() : null;
        }

        @Override
        public final Builder errorDetail(ErrorDetail errorDetail) {
            this.errorDetail = errorDetail;
            return this;
        }

        public final void setErrorDetail(ErrorDetail.BuilderImpl errorDetail) {
            this.errorDetail = errorDetail != null ? errorDetail.build() : null;
        }

        public PartitionError build() {
            return new PartitionError(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PartitionError> {
        public Builder partitionValues(Collection<String> var1);

        public Builder partitionValues(String ... var1);

        public Builder errorDetail(ErrorDetail var1);

        default public Builder errorDetail(Consumer<ErrorDetail.Builder> errorDetail) {
            return this.errorDetail((ErrorDetail)((ErrorDetail.Builder)ErrorDetail.builder().applyMutation(errorDetail)).build());
        }
    }
}

