/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.ParametersMapCopier;
import software.amazon.awssdk.services.glue.model.StorageDescriptor;
import software.amazon.awssdk.services.glue.model.ValueStringListCopier;
import software.amazon.awssdk.services.glue.transform.PartitionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Partition
implements StructuredPojo,
ToCopyableBuilder<Builder, Partition> {
    private final List<String> values;
    private final String databaseName;
    private final String tableName;
    private final Instant creationTime;
    private final Instant lastAccessTime;
    private final StorageDescriptor storageDescriptor;
    private final Map<String, String> parameters;
    private final Instant lastAnalyzedTime;

    private Partition(BuilderImpl builder) {
        this.values = builder.values;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.creationTime = builder.creationTime;
        this.lastAccessTime = builder.lastAccessTime;
        this.storageDescriptor = builder.storageDescriptor;
        this.parameters = builder.parameters;
        this.lastAnalyzedTime = builder.lastAnalyzedTime;
    }

    public List<String> values() {
        return this.values;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public String tableName() {
        return this.tableName;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant lastAccessTime() {
        return this.lastAccessTime;
    }

    public StorageDescriptor storageDescriptor() {
        return this.storageDescriptor;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public Instant lastAnalyzedTime() {
        return this.lastAnalyzedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.values());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAccessTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageDescriptor());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAnalyzedTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Partition)) {
            return false;
        }
        Partition other = (Partition)obj;
        return Objects.equals(this.values(), other.values()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastAccessTime(), other.lastAccessTime()) && Objects.equals(this.storageDescriptor(), other.storageDescriptor()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.lastAnalyzedTime(), other.lastAnalyzedTime());
    }

    public String toString() {
        return ToString.builder((String)"Partition").add("Values", this.values()).add("DatabaseName", (Object)this.databaseName()).add("TableName", (Object)this.tableName()).add("CreationTime", (Object)this.creationTime()).add("LastAccessTime", (Object)this.lastAccessTime()).add("StorageDescriptor", (Object)this.storageDescriptor()).add("Parameters", this.parameters()).add("LastAnalyzedTime", (Object)this.lastAnalyzedTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastAccessTime": {
                return Optional.ofNullable(clazz.cast(this.lastAccessTime()));
            }
            case "StorageDescriptor": {
                return Optional.ofNullable(clazz.cast(this.storageDescriptor()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "LastAnalyzedTime": {
                return Optional.ofNullable(clazz.cast(this.lastAnalyzedTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PartitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> values = DefaultSdkAutoConstructList.getInstance();
        private String databaseName;
        private String tableName;
        private Instant creationTime;
        private Instant lastAccessTime;
        private StorageDescriptor storageDescriptor;
        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();
        private Instant lastAnalyzedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Partition model) {
            this.values(model.values);
            this.databaseName(model.databaseName);
            this.tableName(model.tableName);
            this.creationTime(model.creationTime);
            this.lastAccessTime(model.lastAccessTime);
            this.storageDescriptor(model.storageDescriptor);
            this.parameters(model.parameters);
            this.lastAnalyzedTime(model.lastAnalyzedTime);
        }

        public final Collection<String> getValues() {
            return this.values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ValueStringListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = ValueStringListCopier.copy(values);
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastAccessTime() {
            return this.lastAccessTime;
        }

        @Override
        public final Builder lastAccessTime(Instant lastAccessTime) {
            this.lastAccessTime = lastAccessTime;
            return this;
        }

        public final void setLastAccessTime(Instant lastAccessTime) {
            this.lastAccessTime = lastAccessTime;
        }

        public final StorageDescriptor.Builder getStorageDescriptor() {
            return this.storageDescriptor != null ? this.storageDescriptor.toBuilder() : null;
        }

        @Override
        public final Builder storageDescriptor(StorageDescriptor storageDescriptor) {
            this.storageDescriptor = storageDescriptor;
            return this;
        }

        public final void setStorageDescriptor(StorageDescriptor.BuilderImpl storageDescriptor) {
            this.storageDescriptor = storageDescriptor != null ? storageDescriptor.build() : null;
        }

        public final Map<String, String> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        public final Instant getLastAnalyzedTime() {
            return this.lastAnalyzedTime;
        }

        @Override
        public final Builder lastAnalyzedTime(Instant lastAnalyzedTime) {
            this.lastAnalyzedTime = lastAnalyzedTime;
            return this;
        }

        public final void setLastAnalyzedTime(Instant lastAnalyzedTime) {
            this.lastAnalyzedTime = lastAnalyzedTime;
        }

        public Partition build() {
            return new Partition(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Partition> {
        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);

        public Builder databaseName(String var1);

        public Builder tableName(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastAccessTime(Instant var1);

        public Builder storageDescriptor(StorageDescriptor var1);

        default public Builder storageDescriptor(Consumer<StorageDescriptor.Builder> storageDescriptor) {
            return this.storageDescriptor((StorageDescriptor)((StorageDescriptor.Builder)StorageDescriptor.builder().applyMutation(storageDescriptor)).build());
        }

        public Builder parameters(Map<String, String> var1);

        public Builder lastAnalyzedTime(Instant var1);
    }
}

