/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.ConnectionType;
import software.amazon.awssdk.services.glue.model.MatchCriteriaCopier;
import software.amazon.awssdk.services.glue.transform.GetConnectionsFilterMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConnectionsFilter
implements StructuredPojo,
ToCopyableBuilder<Builder, GetConnectionsFilter> {
    private final List<String> matchCriteria;
    private final String connectionType;

    private GetConnectionsFilter(BuilderImpl builder) {
        this.matchCriteria = builder.matchCriteria;
        this.connectionType = builder.connectionType;
    }

    public List<String> matchCriteria() {
        return this.matchCriteria;
    }

    public ConnectionType connectionType() {
        return ConnectionType.fromValue(this.connectionType);
    }

    public String connectionTypeAsString() {
        return this.connectionType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.matchCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConnectionsFilter)) {
            return false;
        }
        GetConnectionsFilter other = (GetConnectionsFilter)obj;
        return Objects.equals(this.matchCriteria(), other.matchCriteria()) && Objects.equals(this.connectionTypeAsString(), other.connectionTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"GetConnectionsFilter").add("MatchCriteria", this.matchCriteria()).add("ConnectionType", (Object)this.connectionTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MatchCriteria": {
                return Optional.ofNullable(clazz.cast(this.matchCriteria()));
            }
            case "ConnectionType": {
                return Optional.ofNullable(clazz.cast(this.connectionTypeAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GetConnectionsFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> matchCriteria = DefaultSdkAutoConstructList.getInstance();
        private String connectionType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConnectionsFilter model) {
            this.matchCriteria(model.matchCriteria);
            this.connectionType(model.connectionType);
        }

        public final Collection<String> getMatchCriteria() {
            return this.matchCriteria;
        }

        @Override
        public final Builder matchCriteria(Collection<String> matchCriteria) {
            this.matchCriteria = MatchCriteriaCopier.copy(matchCriteria);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchCriteria(String ... matchCriteria) {
            this.matchCriteria(Arrays.asList(matchCriteria));
            return this;
        }

        public final void setMatchCriteria(Collection<String> matchCriteria) {
            this.matchCriteria = MatchCriteriaCopier.copy(matchCriteria);
        }

        public final String getConnectionType() {
            return this.connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(ConnectionType connectionType) {
            this.connectionType(connectionType.toString());
            return this;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        public GetConnectionsFilter build() {
            return new GetConnectionsFilter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetConnectionsFilter> {
        public Builder matchCriteria(Collection<String> var1);

        public Builder matchCriteria(String ... var1);

        public Builder connectionType(String var1);

        public Builder connectionType(ConnectionType var1);
    }
}

