/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.CatalogEncryptionMode;
import software.amazon.awssdk.services.glue.transform.EncryptionAtRestMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EncryptionAtRest
implements StructuredPojo,
ToCopyableBuilder<Builder, EncryptionAtRest> {
    private final String catalogEncryptionMode;
    private final String sseAwsKmsKeyId;

    private EncryptionAtRest(BuilderImpl builder) {
        this.catalogEncryptionMode = builder.catalogEncryptionMode;
        this.sseAwsKmsKeyId = builder.sseAwsKmsKeyId;
    }

    public CatalogEncryptionMode catalogEncryptionMode() {
        return CatalogEncryptionMode.fromValue(this.catalogEncryptionMode);
    }

    public String catalogEncryptionModeAsString() {
        return this.catalogEncryptionMode;
    }

    public String sseAwsKmsKeyId() {
        return this.sseAwsKmsKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogEncryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseAwsKmsKeyId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionAtRest)) {
            return false;
        }
        EncryptionAtRest other = (EncryptionAtRest)obj;
        return Objects.equals(this.catalogEncryptionModeAsString(), other.catalogEncryptionModeAsString()) && Objects.equals(this.sseAwsKmsKeyId(), other.sseAwsKmsKeyId());
    }

    public String toString() {
        return ToString.builder((String)"EncryptionAtRest").add("CatalogEncryptionMode", (Object)this.catalogEncryptionModeAsString()).add("SseAwsKmsKeyId", (Object)this.sseAwsKmsKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogEncryptionMode": {
                return Optional.ofNullable(clazz.cast(this.catalogEncryptionModeAsString()));
            }
            case "SseAwsKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.sseAwsKmsKeyId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EncryptionAtRestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String catalogEncryptionMode;
        private String sseAwsKmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionAtRest model) {
            this.catalogEncryptionMode(model.catalogEncryptionMode);
            this.sseAwsKmsKeyId(model.sseAwsKmsKeyId);
        }

        public final String getCatalogEncryptionMode() {
            return this.catalogEncryptionMode;
        }

        @Override
        public final Builder catalogEncryptionMode(String catalogEncryptionMode) {
            this.catalogEncryptionMode = catalogEncryptionMode;
            return this;
        }

        @Override
        public final Builder catalogEncryptionMode(CatalogEncryptionMode catalogEncryptionMode) {
            this.catalogEncryptionMode(catalogEncryptionMode.toString());
            return this;
        }

        public final void setCatalogEncryptionMode(String catalogEncryptionMode) {
            this.catalogEncryptionMode = catalogEncryptionMode;
        }

        public final String getSseAwsKmsKeyId() {
            return this.sseAwsKmsKeyId;
        }

        @Override
        public final Builder sseAwsKmsKeyId(String sseAwsKmsKeyId) {
            this.sseAwsKmsKeyId = sseAwsKmsKeyId;
            return this;
        }

        public final void setSseAwsKmsKeyId(String sseAwsKmsKeyId) {
            this.sseAwsKmsKeyId = sseAwsKmsKeyId;
        }

        public EncryptionAtRest build() {
            return new EncryptionAtRest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EncryptionAtRest> {
        public Builder catalogEncryptionMode(String var1);

        public Builder catalogEncryptionMode(CatalogEncryptionMode var1);

        public Builder sseAwsKmsKeyId(String var1);
    }
}

