/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.EncryptionAtRest;
import software.amazon.awssdk.services.glue.transform.DataCatalogEncryptionSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataCatalogEncryptionSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, DataCatalogEncryptionSettings> {
    private final EncryptionAtRest encryptionAtRest;

    private DataCatalogEncryptionSettings(BuilderImpl builder) {
        this.encryptionAtRest = builder.encryptionAtRest;
    }

    public EncryptionAtRest encryptionAtRest() {
        return this.encryptionAtRest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionAtRest());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataCatalogEncryptionSettings)) {
            return false;
        }
        DataCatalogEncryptionSettings other = (DataCatalogEncryptionSettings)obj;
        return Objects.equals(this.encryptionAtRest(), other.encryptionAtRest());
    }

    public String toString() {
        return ToString.builder((String)"DataCatalogEncryptionSettings").add("EncryptionAtRest", (Object)this.encryptionAtRest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EncryptionAtRest": {
                return Optional.ofNullable(clazz.cast(this.encryptionAtRest()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DataCatalogEncryptionSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private EncryptionAtRest encryptionAtRest;

        private BuilderImpl() {
        }

        private BuilderImpl(DataCatalogEncryptionSettings model) {
            this.encryptionAtRest(model.encryptionAtRest);
        }

        public final EncryptionAtRest.Builder getEncryptionAtRest() {
            return this.encryptionAtRest != null ? this.encryptionAtRest.toBuilder() : null;
        }

        @Override
        public final Builder encryptionAtRest(EncryptionAtRest encryptionAtRest) {
            this.encryptionAtRest = encryptionAtRest;
            return this;
        }

        public final void setEncryptionAtRest(EncryptionAtRest.BuilderImpl encryptionAtRest) {
            this.encryptionAtRest = encryptionAtRest != null ? encryptionAtRest.build() : null;
        }

        public DataCatalogEncryptionSettings build() {
            return new DataCatalogEncryptionSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DataCatalogEncryptionSettings> {
        public Builder encryptionAtRest(EncryptionAtRest var1);

        default public Builder encryptionAtRest(Consumer<EncryptionAtRest.Builder> encryptionAtRest) {
            return this.encryptionAtRest((EncryptionAtRest)((EncryptionAtRest.Builder)EncryptionAtRest.builder().applyMutation(encryptionAtRest)).build());
        }
    }
}

